/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.fsp.AsyncEventListener;
import com.ibm.hsc.fsp.FSPCMCustomHWSMessage;
import com.ibm.hsc.fsp.FSPCMIdGenerator;
import com.ibm.hsc.fsp.FSPCMRespHdlr;
import com.ibm.hsc.fsp.FspConnErrorHandler;
import com.ibm.hsc.fsp.ManagedSysConn;
import com.ibm.hsc.fsp.PhypExtErrHelper;
import com.ibm.hsc.fsp.cmdhelpers.FspCecInstCmds;
import com.ibm.hsc.fsp.cmdhelpers.FspCecInterfaceImplLimits;
import com.ibm.hsc.fsp.cmdhelpers.FspQueryData;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.frame.OmFrameMgr;
import com.ibm.hsc.objmgr.sys.OmSysMgr;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;

public class FSPCmdMgr
implements FspConnErrorHandler {
    private Hashtable mConnections = new Hashtable();
    private ManagedSysConn mDefConnection = null;
    private OmSysMgr mSysMgr = null;
    private int mCmdState = 1;
    private boolean mClosed = false;
    private FspCecInterfaceImplLimits mIntfLimits = null;
    public static final int SYS_ENABLED = 0;
    public static final int PHYP_ENABLED = 5;
    static final int NO_CONNECTION_HARDWARE_SERVER = 1;
    static final int NO_CONNECTION_TO_SYS = 2;
    static final int AUTH_PENDING = 4;
    static final int DELETED = 3;
    private static final int[] mStateToNdx = new int[]{0, 1, 4, 8, 16, 11, 32768, 32769, 32770, 32771, 32772, 32773, 32774, 32775};
    private static final int[] mCmdStateTable = new int[]{0, 2, 2, 4, 0, 4, 2, 2, 2, 2, 2, 4, 2, 2};
    private static final short[] mSysStateTable = new short[]{4, 254, 254, 14, 14, 242, 254, 254, 254, 254, 254, 241, 254, 250};
    private static final boolean[][] mStateTable = new boolean[][]{{true, true, true, true, true, true, true, true, true, true, true, true, true, false}, {false, true, false, false, false, false, true, true, true, true, true, true, true, false}, {false, true, true, false, false, false, true, true, true, true, true, true, true, false}, {false, true, true, true, false, false, true, true, true, true, true, true, true, false}, {false, true, true, true, true, true, true, true, true, true, true, true, true, false}, {false, true, true, false, false, true, true, true, true, true, true, false, true, false}, {false, false, false, false, false, false, true, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, true, true, true, true, false, false, false, false}, {false, false, false, false, false, false, true, true, true, false, true, false, false, false}, {false, true, false, false, false, true, true, true, true, true, true, true, false, false}, {false, false, false, false, false, false, true, true, true, false, true, false, true, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true}};
    public static final int SEND_TO_SINGLE_BY_IP = 0;
    public static final int SEND_TO_SINGLE_BY_LOC_CODE = 1;
    public static final int SEND_TO_DFAULTE_CONN = 2;
    public static final int SEND_TO_ALL_CONN = 3;
    public static final int SEND_TO_EVERY_CONN = 4;

    public FSPCmdMgr(OmSysMgr omSysMgr) {
        this.mSysMgr = omSysMgr;
    }

    public void updateQueryData(FspQueryData fspQueryData, byte[] byArray) throws PIHscCmdMgrException {
        Integer n = new Integer(HardwareServerMessage.bytesToUInt(byArray, 0));
        ManagedSysConn managedSysConn = null;
        if (fspQueryData.getCmdServerConnState().intValue() == 65534) {
            if (!this.mClosed) {
                this.removeConn(n);
            }
            return;
        }
        if (this.mClosed) {
            this.mClosed = false;
            this.mConnections = new Hashtable();
        }
        if ((managedSysConn = (ManagedSysConn)this.mConnections.get(n)) != null) {
            managedSysConn.updateData(fspQueryData);
        } else {
            managedSysConn = new ManagedSysConn(this, n, this.getAsyncListener(), this, fspQueryData);
            System.out.println("add new vport conn " + n);
            this.mConnections.put(n, managedSysConn);
        }
        this.mDefConnection = this.getDefConnection(managedSysConn);
        System.out.println("mDefConnection " + this.mDefConnection);
        if (this.mDefConnection == null) {
            return;
        }
        int n2 = this.getConnCmdState(this.mDefConnection);
        if (this.isFsp() && n2 == 0 && this.mCmdState != 0 && this.mCmdState != 5 || !this.isFsp() && managedSysConn.isConnected()) {
            try {
                this.getAsyncListener().initialize(byArray, this.isFsp());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (this.mCmdState == 5 && n2 == 0) {
            return;
        }
        if ((this.mCmdState == 5 || this.mCmdState == 0 || this.mCmdState == 4) && n2 == 2) {
            this.disable(2);
        }
        this.mCmdState = n2;
    }

    private void removeConn(Integer n) {
        ManagedSysConn managedSysConn = (ManagedSysConn)this.mConnections.remove(n);
        if (managedSysConn != null) {
            managedSysConn.close();
        }
        if (this.mConnections.size() < 1) {
            this.close(true);
        } else {
            if (this.isFsp() && managedSysConn == this.mDefConnection) {
                this.mDefConnection = null;
                this.mCmdState = 2;
            }
            if (!this.isFsp()) {
                this.mDefConnection = (ManagedSysConn)this.mConnections.elements().nextElement();
                this.mCmdState = this.getConnCmdState(this.mDefConnection);
            }
        }
    }

    private ManagedSysConn getDefConnection(ManagedSysConn managedSysConn) {
        if (!this.isFsp()) {
            return this.getBestConn(managedSysConn);
        }
        ManagedSysConn managedSysConn2 = this.getPrimaryConnection();
        if (managedSysConn2 == null) {
            this.mCmdState = 2;
            return null;
        }
        if (managedSysConn.isPrimary()) {
            if (managedSysConn == managedSysConn2) {
                this.resetOtherPrimaryConns(managedSysConn);
            } else {
                this.sendResetFailCmd(managedSysConn2);
            }
        }
        return managedSysConn2;
    }

    private void resetOtherPrimaryConns(ManagedSysConn managedSysConn) {
        if (managedSysConn.getConnState() != 0) {
            return;
        }
        Enumeration enumeration = this.mConnections.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            ManagedSysConn managedSysConn2 = (ManagedSysConn)this.mConnections.get(n);
            if (managedSysConn2 == managedSysConn || !managedSysConn2.isPrimary() || !managedSysConn2.isConnected()) continue;
            new FspCecInstCmds().removeSysByVport(this, managedSysConn2.getConnState(), (byte)1, n, managedSysConn2.getIpAddr(), 105);
        }
    }

    private void sendResetFailCmd(ManagedSysConn managedSysConn) {
        if (managedSysConn.getConnState() != 0 || managedSysConn.everRunResetFailCmd()) {
            return;
        }
        try {
            managedSysConn.internalRunCmd("RESET_FAIL_OVER_FSP", null, 0, null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        managedSysConn.setEverRunResetFailCmd();
    }

    public boolean hasConnection() {
        return this.mDefConnection != null;
    }

    public int getCmdState() {
        return this.mCmdState;
    }

    public short getSysState() {
        return mSysStateTable[this.getStateNdx(this.getConnState())];
    }

    private int getConnCmdState(ManagedSysConn managedSysConn) {
        return mCmdStateTable[this.getStateNdx(managedSysConn.getConnState())];
    }

    private int getStateNdx(int n) {
        for (int i = 0; i < mStateToNdx.length; ++i) {
            if (n != mStateToNdx[i]) continue;
            return i;
        }
        System.out.println("invald conn state " + n);
        return 6;
    }

    private boolean compareConnState(int n, int n2) {
        System.out.println("compare state: " + n + " and " + n2);
        int n3 = this.getStateNdx(n);
        int n4 = this.getStateNdx(n2);
        return mStateTable[n3][n4];
    }

    private ManagedSysConn getBestConn(ManagedSysConn managedSysConn) {
        Enumeration enumeration = this.mConnections.elements();
        while (enumeration.hasMoreElements()) {
            ManagedSysConn managedSysConn2 = (ManagedSysConn)enumeration.nextElement();
            if (this.compareConnState(managedSysConn.getConnState(), managedSysConn2.getConnState())) continue;
            managedSysConn = managedSysConn2;
        }
        return managedSysConn;
    }

    public String getLocationCodeByVport(int n) {
        if (this.isClosed()) {
            return null;
        }
        ManagedSysConn managedSysConn = (ManagedSysConn)this.mConnections.get(new Integer(n));
        if (managedSysConn == null) {
            return null;
        }
        return managedSysConn.getLocCode();
    }

    public boolean isConnIp(String string) {
        if (this.isClosed()) {
            return false;
        }
        Enumeration enumeration = this.mConnections.elements();
        while (enumeration.hasMoreElements()) {
            ManagedSysConn managedSysConn = (ManagedSysConn)enumeration.nextElement();
            String string2 = managedSysConn.getIpAddr();
            if (string.equals(string2)) {
                return true;
            }
            try {
                InetAddress inetAddress = InetAddress.getByName(string2);
                String string3 = inetAddress.getHostAddress();
                if (string.equals(string3)) {
                    return true;
                }
                System.out.println("targetIpAddr = " + string3);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return false;
    }

    private ManagedSysConn getPrimaryConnection() {
        System.out.println("mConnections.size() " + this.mConnections.size());
        Enumeration enumeration = this.mConnections.elements();
        ManagedSysConn managedSysConn = null;
        int n = -1;
        while (enumeration.hasMoreElements()) {
            ManagedSysConn managedSysConn2 = (ManagedSysConn)enumeration.nextElement();
            int n2 = managedSysConn2.getPrimaryCount();
            System.out.println("tempCnt: " + n2);
            System.out.println("isPrimary: " + managedSysConn2.isPrimary());
            if (!managedSysConn2.isPrimary() || n2 <= n) continue;
            n = n2;
            if (managedSysConn != null) {
                managedSysConn.setLocCode("FAIL_OVER_PRIMARY");
            }
            managedSysConn = managedSysConn2;
        }
        return managedSysConn;
    }

    private ManagedSysConn getByIpAddr(String string) {
        Enumeration enumeration = this.mConnections.elements();
        while (enumeration.hasMoreElements()) {
            ManagedSysConn managedSysConn = (ManagedSysConn)enumeration.nextElement();
            String string2 = managedSysConn.getIpAddr();
            if (!string.equals(string2)) continue;
            return managedSysConn;
        }
        return null;
    }

    private ManagedSysConn getByLocCode(String string) {
        Enumeration enumeration = this.mConnections.elements();
        while (enumeration.hasMoreElements()) {
            ManagedSysConn managedSysConn = (ManagedSysConn)enumeration.nextElement();
            String string2 = managedSysConn.getLocCode();
            if (!string.equals(string2)) continue;
            return managedSysConn;
        }
        return null;
    }

    public String getIPAddr() {
        if (this.mDefConnection == null) {
            return null;
        }
        return this.mDefConnection.getIpAddr();
    }

    public int getVport() {
        if (this.mDefConnection == null) {
            return -1;
        }
        return this.mDefConnection.getVport();
    }

    public void close(boolean bl) {
        System.out.println("closing the cmd mgr for" + this.mSysMgr.getSysName());
        if (this.mClosed) {
            System.out.println("cmd mgr already closed do nothing");
            return;
        }
        this.mClosed = true;
        Enumeration enumeration = this.mConnections.elements();
        while (enumeration.hasMoreElements()) {
            ManagedSysConn managedSysConn = (ManagedSysConn)enumeration.nextElement();
            managedSysConn.close();
        }
        if (bl) {
            this.disable(3);
        } else {
            this.disable(1);
        }
        this.mConnections = null;
        this.mDefConnection = null;
        this.mCmdState = 1;
    }

    public String getHypPipeAsychCmd(int n) {
        if (this.mDefConnection == null) {
            return null;
        }
        return this.mDefConnection.getHypPipeAsychCmd(n);
    }

    public int processGroupResponse(byte[] byArray, int n) {
        if (this.mDefConnection == null) {
            return -1;
        }
        return this.mDefConnection.processGroupResponse(byArray, n);
    }

    public Hashtable doPhypCommand(String string, String[] stringArray) throws PIHscCmdMgrException {
        return this.doPhypCommand(string, stringArray, null);
    }

    public Hashtable doPhypCommand(String string, String[] stringArray, UnsignedInt32 unsignedInt32) throws PIHscCmdMgrException {
        return this.doPhypCommand(string, stringArray, 0, null, unsignedInt32, null, null, null);
    }

    public void setPhypReady(boolean bl) {
        if (bl && this.mCmdState == 0) {
            this.mCmdState = 5;
        }
        if (!bl && this.mCmdState == 5) {
            this.mCmdState = 0;
        }
    }

    public Hashtable doPhypCommand(String string, String[] stringArray, int n, byte[] byArray, UnsignedInt32 unsignedInt32, UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, UnsignedInt16 unsignedInt163) throws PIHscCmdMgrException {
        if (this.mCmdState == 0) {
            System.out.println("doPhypCmd FSP_CEC_PHYP_NOT_READY " + string);
            throw new PIHscCmdMgrException("025D", new String[]{string}, (PIHscCmdMgrException)null);
        }
        try {
            return this.doFSPCommand(string, stringArray, n, byArray);
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            pIHscCmdMgrException.printStackTrace();
            PhypExtErrHelper phypExtErrHelper = PhypExtErrHelper.getInstance();
            Hashtable hashtable = phypExtErrHelper.getInParams(this.mSysMgr, unsignedInt32, unsignedInt16, unsignedInt162, unsignedInt163);
            throw phypExtErrHelper.convertException(this.mSysMgr, hashtable, pIHscCmdMgrException);
        }
    }

    public Hashtable doFSPCommand(String string) throws PIHscCmdMgrException {
        return this.doFSPCommand(string, null, 0, null);
    }

    public Hashtable doFSPCommand(String string, int n) throws PIHscCmdMgrException {
        return this.doFSPCommand(string, null, n, null);
    }

    public Hashtable doFSPCommand(String string, String[] stringArray) throws PIHscCmdMgrException {
        return this.doFSPCommand(string, stringArray, 0, null);
    }

    public Hashtable doFSPCommand(String string, String[] stringArray, String string2) throws PIHscCmdMgrException {
        if (string2 != null) {
            return this.doFSPCommand(string, stringArray, 0, null, 1, string2);
        }
        return this.doFSPCommand(string, stringArray, 0, null);
    }

    public Hashtable doFSPCommand(String string, String[] stringArray, int n) throws PIHscCmdMgrException {
        return this.doFSPCommand(string, stringArray, n, null);
    }

    public Hashtable doFSPCommand(String string, String[] stringArray, int n, byte[] byArray) throws PIHscCmdMgrException {
        return this.doFSPCommand(string, stringArray, n, byArray, 2, null);
    }

    public Hashtable doBPACommand(String string, String[] stringArray, int n) throws PIHscCmdMgrException {
        return this.doBPACommand(string, stringArray, n, 4, null);
    }

    public Hashtable doBPACommand(String string, String[] stringArray, int n, int n2, String string2) throws PIHscCmdMgrException {
        if (!(this.mSysMgr instanceof OmFrameMgr)) {
            System.out.println("mSysMgr.getClass().getName(): " + this.mSysMgr.getClass().getName());
            String string3 = "The command manager is not for frame";
            throw new PIHscCmdMgrException(string3, (Throwable)null);
        }
        return this.doFSPCommand(string, stringArray, n, null, n2, string2);
    }

    public Hashtable doFSPCommand(String string, String[] stringArray, int n, byte[] byArray, int n2, String string2) throws PIHscCmdMgrException {
        if (this.mCmdState == 1) {
            System.out.println("do fsp cmd FSP_NO_HS_CONN: " + string);
            throw new PIHscCmdMgrException("0251", new String[]{string}, (PIHscCmdMgrException)null);
        }
        if (this.mCmdState == 2 && n2 == 2) {
            System.out.println("do fsp cmd FSP_NO_FSP_CONN: " + string);
            throw new PIHscCmdMgrException("0252", new String[]{string}, (PIHscCmdMgrException)null);
        }
        if (this.mCmdState == 3) {
            System.out.println("do fsp cmd FSP_CEC_DELETED: " + string);
            throw new PIHscCmdMgrException("0253", new String[]{string}, (PIHscCmdMgrException)null);
        }
        if (this.mCmdState == 4) {
            System.out.println("do fsp cmd FSP_CEC_AUTH_PENDING:" + string);
            throw new PIHscCmdMgrException("025C", new String[]{string}, (PIHscCmdMgrException)null);
        }
        return this.internalCmd(string, stringArray, n, byArray, n2, string2);
    }

    private Hashtable internalCmd(String string, String[] stringArray, int n, byte[] byArray, int n2, String string2) throws PIHscCmdMgrException {
        ManagedSysConn managedSysConn = null;
        int n3 = 0;
        System.out.println("sendTo: " + n2 + " dest " + string2);
        if (n2 == 0 || n2 == 1) {
            if (string2 == null) {
                throw new PIHscCmdMgrException("0265", new String[]{string}, (PIHscCmdMgrException)null);
            }
            if (n2 == 0) {
                managedSysConn = this.getByIpAddr(string2);
            }
            if (n2 == 1) {
                managedSysConn = this.getByLocCode(string2);
            }
            if (managedSysConn == null) {
                System.out.println("FSP_CONN_NOT_AVAILABLE");
                throw new PIHscCmdMgrException("0270", new String[]{string2, string}, (PIHscCmdMgrException)null);
            }
            n3 = this.getConnCmdState(managedSysConn);
            if (n3 != 0 && n3 != 5) {
                System.out.println("invalid conn state: " + n3);
                throw new PIHscCmdMgrException("0271", new String[]{string2, string}, (PIHscCmdMgrException)null);
            }
            return managedSysConn.internalRunCmd(string, stringArray, n, byArray);
        }
        Enumeration enumeration = null;
        managedSysConn = this.mDefConnection;
        boolean bl = false;
        PIHscCmdMgrException pIHscCmdMgrException = null;
        Hashtable hashtable = null;
        while (true) {
            try {
                boolean bl2;
                n3 = this.getConnCmdState(managedSysConn);
                System.out.println("state " + n3);
                boolean bl3 = bl2 = n3 == 0;
                if (!(bl2 || n3 != 5 && n3 != 4)) {
                    if (n2 != 2 && managedSysConn != this.mDefConnection) {
                        System.out.println("second conn has invalid state: " + n3);
                    } else {
                        bl2 = true;
                    }
                }
                if (bl2) {
                    hashtable = managedSysConn.internalRunCmd(string, stringArray, n, byArray);
                    if (n2 == 2 || n2 == 4) {
                        return hashtable;
                    }
                }
            }
            catch (PIHscCmdMgrException pIHscCmdMgrException2) {
                pIHscCmdMgrException2.printStackTrace();
                if (n2 == 2 || n2 == 3) {
                    throw pIHscCmdMgrException2;
                }
                pIHscCmdMgrException = pIHscCmdMgrException2;
            }
            if (enumeration == null) {
                enumeration = this.mConnections.elements();
            }
            do {
                if (enumeration != null && enumeration.hasMoreElements()) continue;
                if (pIHscCmdMgrException == null) {
                    return hashtable;
                }
                throw pIHscCmdMgrException;
            } while ((managedSysConn = (ManagedSysConn)enumeration.nextElement()) == this.mDefConnection);
        }
    }

    public Hashtable customFSPCommand(String string, String[] stringArray, int n) throws PIHscCmdMgrException {
        if (this.mCmdState == 1) {
            System.out.println("do fsp cmd FSP_NO_HS_CONN: " + string);
            throw new PIHscCmdMgrException("0251", new String[]{string}, (PIHscCmdMgrException)null);
        }
        if (this.mCmdState == 2) {
            System.out.println("do fsp cmd FSP_NO_FSP_CONN: " + string);
            throw new PIHscCmdMgrException("0252", new String[]{string}, (PIHscCmdMgrException)null);
        }
        if (this.mCmdState == 3) {
            System.out.println("do fsp cmd FSP_CEC_DELETED: " + string);
            throw new PIHscCmdMgrException("0253", new String[]{string}, (PIHscCmdMgrException)null);
        }
        if (this.mCmdState == 4) {
            System.out.println("do fsp cmd FSP_CEC_AUTH_PENDING:" + string);
            throw new PIHscCmdMgrException("025C", new String[]{string}, (PIHscCmdMgrException)null);
        }
        return this.internalCmd(string, stringArray, n, null, 2, null);
    }

    public Hashtable doAuthCommand(String string, String[] stringArray, int n) throws PIHscCmdMgrException {
        if (this.mCmdState == 1) {
            System.out.println("do auth cmd NO_CONNECTION_HARDWARE_SERVER:" + string);
            PIHscCmdMgrException pIHscCmdMgrException = new PIHscCmdMgrException("0251", new String[]{string}, (PIHscCmdMgrException)null);
            pIHscCmdMgrException.setStatus(1);
            throw pIHscCmdMgrException;
        }
        if (this.mCmdState == 2) {
            System.out.println("do auth cmd NO_CONNECTION_TO_SYS: " + string);
            PIHscCmdMgrException pIHscCmdMgrException = new PIHscCmdMgrException("0252", new String[]{string}, (PIHscCmdMgrException)null);
            pIHscCmdMgrException.setStatus(1);
            throw pIHscCmdMgrException;
        }
        if (this.mCmdState == 3) {
            System.out.println("do auth cmd DELETED:" + string);
            PIHscCmdMgrException pIHscCmdMgrException = new PIHscCmdMgrException("0253", new String[]{string}, (PIHscCmdMgrException)null);
            pIHscCmdMgrException.setStatus(1);
            throw pIHscCmdMgrException;
        }
        return this.internalCmd(string, stringArray, n, null, 2, null);
    }

    public HardwareServerMessage doHardwareServerCmd(String string, FSPCMCustomHWSMessage fSPCMCustomHWSMessage, byte[] byArray, int n, ManagedSysConn managedSysConn) throws PIHscCmdMgrException {
        if (this.mCmdState == 1) {
            System.out.println("no conn to hdwr_svr" + string);
            throw new PIHscCmdMgrException("0251", new String[]{string}, (PIHscCmdMgrException)null);
        }
        if (this.mCmdState == 3 || this.mClosed) {
            System.out.println("conn deleted or closed mCmdState " + this.mCmdState + " mClosed " + this.mClosed + " cmd " + string);
            throw new PIHscCmdMgrException("0253", new String[]{string}, (PIHscCmdMgrException)null);
        }
        return managedSysConn.doHardwareServerCmd(string, fSPCMCustomHWSMessage, byArray, n);
    }

    public HardwareServerMessage doHardwareServerCmd(String string, FSPCMCustomHWSMessage fSPCMCustomHWSMessage, byte[] byArray, int n) throws PIHscCmdMgrException {
        return this.doHardwareServerCmd(string, fSPCMCustomHWSMessage, byArray, n, this.mDefConnection);
    }

    public HardwareServerMessage doHardwareServerCmd(String string, FSPCMCustomHWSMessage fSPCMCustomHWSMessage, byte[] byArray, int n, Integer n2) throws PIHscCmdMgrException {
        ManagedSysConn managedSysConn = (ManagedSysConn)this.mConnections.get(n2);
        if (managedSysConn != null) {
            return this.doHardwareServerCmd(string, fSPCMCustomHWSMessage, byArray, n, managedSysConn);
        }
        System.out.println("invalid vport for doHardware cmd " + n2);
        return null;
    }

    public Hashtable doHardwareServerCmdAllDest(String string, FSPCMCustomHWSMessage fSPCMCustomHWSMessage, byte[] byArray, int n) throws PIHscCmdMgrException {
        Hashtable<String, HardwareServerMessage> hashtable = new Hashtable<String, HardwareServerMessage>();
        PIHscServerException pIHscServerException = null;
        Enumeration enumeration = this.mConnections.elements();
        while (enumeration.hasMoreElements()) {
            ManagedSysConn managedSysConn = (ManagedSysConn)enumeration.nextElement();
            try {
                HardwareServerMessage hardwareServerMessage = this.doHardwareServerCmd(string, fSPCMCustomHWSMessage, byArray, n, managedSysConn);
                hashtable.put(managedSysConn.getIpAddr(), hardwareServerMessage);
            }
            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                pIHscCmdMgrException.printStackTrace();
                pIHscServerException = pIHscCmdMgrException;
            }
        }
        if (pIHscServerException != null) {
            pIHscServerException.printStackTrace();
            throw pIHscServerException;
        }
        return hashtable;
    }

    public int[] doGroupCmd(Vector vector, String string, String string2, int[] nArray, FSPCMRespHdlr fSPCMRespHdlr, int n) throws PIHscCmdMgrException {
        byte[] byArray = (byte[])vector.elementAt(0);
        System.out.println("tmpcmd: " + byArray);
        String string3 = new String(byArray);
        if (this.mCmdState == 1) {
            System.out.println("doGroupCmd FSP_NO_HS_CONN " + string3);
            throw new PIHscCmdMgrException("0251", new String[]{string3}, (PIHscCmdMgrException)null);
        }
        if (this.mCmdState == 2) {
            System.out.println("doGroupCmd FSP_NO_FSP_CONN " + string3);
            throw new PIHscCmdMgrException("0252", new String[]{string3}, (PIHscCmdMgrException)null);
        }
        if (this.mCmdState == 3) {
            System.out.println("doGroupCmd FSP_CEC_DELETED " + string3);
            throw new PIHscCmdMgrException("0253", new String[]{string3}, (PIHscCmdMgrException)null);
        }
        if (this.mCmdState == 4) {
            System.out.println("doGroupCmd FSP_CEC_AUTH_PENDING " + string3);
            throw new PIHscCmdMgrException("025C", new String[]{string3}, (PIHscCmdMgrException)null);
        }
        return this.mDefConnection.doGroupCmd(vector, string, string2, nArray, fSPCMRespHdlr, n);
    }

    public OmSysMgr getOmSysMgr() {
        return this.mSysMgr;
    }

    public AsyncEventListener getAsyncListener() {
        return this.mSysMgr.getAsyncListener();
    }

    public void hwSrvDisconnected(long l) {
        this.close(false);
        this.mSysMgr.hwSrvDisconnected(l);
    }

    private void disable(int n) {
        this.mIntfLimits = null;
        if (this.mCmdState == n) {
            return;
        }
        this.mCmdState = n;
        if (this.mCmdState == 3) {
            this.getAsyncListener().close();
        } else {
            this.getAsyncListener().clearMsgTable();
        }
    }

    public int getConnState() {
        if (this.mDefConnection == null) {
            return 32768;
        }
        return this.mDefConnection.getConnState();
    }

    public boolean isFsp() {
        return this.mSysMgr instanceof OmCecMgr;
    }

    public void sysDisconnected(long l) {
        if (!this.isFsp()) {
            this.mDefConnection = this.getBestConn(this.mDefConnection);
            this.mCmdState = this.getConnCmdState(this.mDefConnection);
        }
        if (this.mDefConnection == null) {
            return;
        }
        if (!this.mDefConnection.isConnected()) {
            this.disable(2);
            this.mCmdState = 2;
            this.mSysMgr.sysDisconnected(l);
        }
    }

    public String getSPVersion() {
        if (this.mDefConnection != null) {
            return this.mDefConnection.getSPVersion();
        }
        return null;
    }

    public FspQueryData getQueryData() {
        if (this.mDefConnection == null) {
            System.out.println("mDefConnection == null");
            return null;
        }
        return this.mDefConnection.getQueryData();
    }

    public FspCecInterfaceImplLimits getInterfaceLimits() throws PIHscServerException {
        if (this.mIntfLimits == null) {
            FspCecInterfaceImplLimits fspCecInterfaceImplLimits = new FspCecInterfaceImplLimits(this);
            fspCecInterfaceImplLimits.getInterfaceImplLimitsCmd();
            this.mIntfLimits = fspCecInterfaceImplLimits;
        }
        return this.mIntfLimits;
    }

    public int genCmdId() {
        return FSPCMIdGenerator.getInstance().genCmdId();
    }

    public String getSysName() {
        return this.mSysMgr.getSysName();
    }

    public Vector getAllIpAddrs() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.mConnections.elements();
        while (enumeration.hasMoreElements()) {
            ManagedSysConn managedSysConn = (ManagedSysConn)enumeration.nextElement();
            vector.addElement(managedSysConn.getIpAddr());
        }
        return vector;
    }

    public Hashtable getAllConnInfo() {
        Hashtable<Integer, FspQueryData> hashtable = new Hashtable<Integer, FspQueryData>();
        if (this.isClosed()) {
            return hashtable;
        }
        Enumeration enumeration = this.mConnections.elements();
        while (enumeration.hasMoreElements()) {
            ManagedSysConn managedSysConn = (ManagedSysConn)enumeration.nextElement();
            if (managedSysConn.getQueryData() == null) continue;
            hashtable.put(new Integer(managedSysConn.getVport()), managedSysConn.getQueryData());
        }
        return hashtable;
    }

    public boolean isClosed() {
        return this.mClosed;
    }
}

